Public Class frmMagicSquare
  Inherits System.Windows.Forms.Form
  Dim txtElement(81) As TextBox
  Dim MatrixSize As Integer

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call   

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Friend WithEvents Label1 As System.Windows.Forms.Label
  Friend WithEvents txtSize As System.Windows.Forms.TextBox
  Friend WithEvents btnCalc As System.Windows.Forms.Button
  Friend WithEvents btnExit As System.Windows.Forms.Button
  Friend WithEvents txtMagicNumber As System.Windows.Forms.TextBox
  Friend WithEvents lblMagicNumber As System.Windows.Forms.Label
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.Label1 = New System.Windows.Forms.Label()
    Me.txtSize = New System.Windows.Forms.TextBox()
    Me.btnCalc = New System.Windows.Forms.Button()
    Me.btnExit = New System.Windows.Forms.Button()
    Me.txtMagicNumber = New System.Windows.Forms.TextBox()
    Me.lblMagicNumber = New System.Windows.Forms.Label()
    Me.SuspendLayout()
    '
    'Label1
    '
    Me.Label1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Label1.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Label1.Location = New System.Drawing.Point(8, 8)
    Me.Label1.Name = "Label1"
    Me.Label1.Size = New System.Drawing.Size(104, 20)
    Me.Label1.TabIndex = 0
    Me.Label1.Text = "Enter matrix size:"
    Me.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'txtSize
    '
    Me.txtSize.Location = New System.Drawing.Point(112, 8)
    Me.txtSize.Name = "txtSize"
    Me.txtSize.TabIndex = 1
    Me.txtSize.Text = "txtSize"
    '
    'btnCalc
    '
    Me.btnCalc.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnCalc.Location = New System.Drawing.Point(224, 8)
    Me.btnCalc.Name = "btnCalc"
    Me.btnCalc.Size = New System.Drawing.Size(80, 24)
    Me.btnCalc.TabIndex = 3
    Me.btnCalc.Text = "&Calculate"
    '
    'btnExit
    '
    Me.btnExit.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnExit.Location = New System.Drawing.Point(224, 40)
    Me.btnExit.Name = "btnExit"
    Me.btnExit.Size = New System.Drawing.Size(80, 24)
    Me.btnExit.TabIndex = 4
    Me.btnExit.Text = "E&xit"
    '
    'txtMagicNumber
    '
    Me.txtMagicNumber.Location = New System.Drawing.Point(112, 40)
    Me.txtMagicNumber.Name = "txtMagicNumber"
    Me.txtMagicNumber.TabIndex = 6
    Me.txtMagicNumber.Text = "txtMagixNumber"
    '
    'lblMagicNumber
    '
    Me.lblMagicNumber.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.lblMagicNumber.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.lblMagicNumber.Location = New System.Drawing.Point(8, 40)
    Me.lblMagicNumber.Name = "lblMagicNumber"
    Me.lblMagicNumber.Size = New System.Drawing.Size(104, 20)
    Me.lblMagicNumber.TabIndex = 5
    Me.lblMagicNumber.Text = "Magic Number:"
    Me.lblMagicNumber.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'frmMagicSquare
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(320, 273)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.txtMagicNumber, Me.lblMagicNumber, Me.btnExit, Me.btnCalc, Me.txtSize, Me.Label1})
    Me.Name = "frmMagicSquare"
    Me.Text = "Magic Squares"
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub InitializeTextboxes()
    ' Purpose:  To initialize the array of text boxes.
    Dim i As Integer
    Dim BoxName As String
    Dim MySize As Size

    MySize.Width = 30
    MySize.Height = 20
    For i = 1 To 81            ' since max size is 9
      txtElement(i) = New TextBox()
      Me.Controls.Add(txtElement(i))
      With txtElement(i)
        .Size = MySize
        .TextAlign = HorizontalAlignment.Center
        .Visible = False
        .Name = "txtElement(" & CStr(i) & ")"
      End With
    Next i
    txtMagicNumber.Visible = False
    lblMagicNumber.Visible = False

  End Sub
  Private Sub HideUsedTextboxes()
    Dim i As Integer

    If MatrixSize > 0 Then          ' Been here before?
      For i = 1 To MatrixSize * MatrixSize
        txtElement(i).Visible = False
      Next i
    End If

  End Sub

  Private Function CheckForValidMatrix() As Integer
    ' Purpose:  This just checks to see that the matrix 
    '           size is greater than 0, less than 10 and
    '           is an odd number.

    If txtSize.Text = "" Then   ' Nothing entered by user
      Beep()
      MsgBox("Need an odd integer 1 through 9")
      txtSize.Focus()
      CheckForValidMatrix = True
      txtMagicNumber.Visible = False
      lblMagicNumber.Visible = False
      Exit Function
    End If
    ' Something was entered. See if it is an odd number
    ' and between 1 and 9.
    MatrixSize = CInt(txtSize.Text)
    If MatrixSize Mod 2 = 0 Or MatrixSize > 9 Or MatrixSize < 1 Then
      MsgBox("Positive odd sizes only, max of 9")
      txtSize.Focus()
      CheckForValidMatrix = True
      txtMagicNumber.Visible = False
      lblMagicNumber.Visible = False
      Exit Function
    End If
    CheckForValidMatrix = False

  End Function

  Private Sub ShowMatrix()
    ' Purpose:  This just displays the matrix
    Dim i, j, k, offset, sum As Integer
    Dim Coor As Point

    sum = 0
    k = 1
    offset = 80                       ' Pixels from edge
    For i = 0 To MatrixSize - 1       ' rows
      For j = 0 To MatrixSize - 1     ' columns
        Coor.X = 30 * j + 12          ' Position
        Coor.Y = offset
        With txtElement(k)
          .Location = Coor ' Set location
          .Text = CStr(Magic(i + 1, j + 1, MatrixSize))
          .Visible = True
        End With
        k += 1
      Next j
      sum += CInt(txtElement(i + 1).Text)
      offset += 20
    Next i

    txtMagicNumber.Text = CStr(sum)
    txtMagicNumber.Visible = True
    lblMagicNumber.Visible = True

  End Sub

  Private Sub btnCalc_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCalc.Click

    If MatrixSize > 0 Then          ' Been here before?
      HideUsedTextboxes()
    End If

    If CheckForValidMatrix() Then   ' Matrix size ok?
      Exit Sub
    End If

    ShowMatrix()                    ' Show it

  End Sub

  Private Function Magic(ByVal row As Integer, ByVal col As Integer, ByVal MatrixSize As Integer) As Integer
    ' Purpose:  This function determines the values for
    '           the magic squares matrix.
    '
    ' Parameters:
    '   row           the current row of the matrix
    '   col           the current column of the matrix
    '   MatrixSize    the size of the matrix
    '
    ' Return Value:
    '   integer       the value for the current row-
    '                 column position.

    Dim term1 As Integer, term2 As Integer

    term1 = col - row + (MatrixSize - 1) \ 2
    term2 = col + col - row
    If term1 >= MatrixSize Then
      term1 -= MatrixSize
    ElseIf term1 < 0 Then
      term1 += MatrixSize
    End If

    If term2 > MatrixSize Then
      term2 -= MatrixSize
    ElseIf term2 <= 0 Then
      term2 += MatrixSize
    End If
    Magic = term1 * MatrixSize + term2  ' The number for the cell
  End Function

  Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
    Me.Dispose()
  End Sub

  Private Sub frmMagicSquare_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    Dim ctl As Control
    Dim i As Integer

    InitializeTextboxes()
    For Each ctl In Controls
      Console.WriteLine(CStr(i) & " = " & Controls(i).Name)
      i += 1
    Next ctl

  End Sub
End Class
